#pragma once
#include <vector>
#include <iostream>
//#include <windows.h>
#include <comdef.h> 

using namespace std ;

enum MeshType
{
    None,
    ScreenQuad,
    TestTriangle,
    MetaBalls
};

struct SequenceSeed
{
    float       duration;
    const char* VSPath;
    const char* PSPath;
    const char* texturePath;
    MeshType    meshType; 

    SequenceSeed& operator=(const SequenceSeed& element)
    {
        this->duration      = element.duration;
        this->VSPath        = element.VSPath;
        this->PSPath        = element.PSPath;
        this->texturePath   = element.texturePath;
        this->meshType      = element.meshType;
        return *this;
    }
};

struct Interval
{
    float inf;
    float sup;
};

class SequenceManager
{
public:
                                    SequenceManager()
                                        : m_TotalDuration(0), 
                                        m_seeds(NULL),
                                        m_intervals(NULL),
                                        m_lastSequenceIndex(-1)
                                    {
                                    };
                                    ~SequenceManager()
                                    {
                                       ReleaseSeeds(); 
                                    }

    const vector<SequenceSeed>&     GetSeeds() const { return *m_seeds;}
    const SequenceSeed              GetSeed(size_t index) const { return m_seeds->at(index);}
    const Interval                  GetInterval(size_t index) const { return m_intervals->at(index);}
    const float&                    GetTotalTime() const { return m_TotalDuration;}

    void                            Init(const SequenceSeed initArray[], size_t count)
    {
        ReleaseSeeds();
        m_seeds = new vector<SequenceSeed>(initArray, initArray+count);
        m_intervals = new std::vector<Interval>(count);

        size_t index =0;
        for (const SequenceSeed& seed: (*m_seeds))
        {
            Interval& interval = m_intervals->at(index);
            interval.inf = m_TotalDuration;
            m_TotalDuration += seed.duration;
            interval.sup = m_TotalDuration;
            ++index;
        }      
    }

    void ReleaseSeeds() 
    {
        if(m_seeds) 
        {
            m_seeds->clear();
            delete m_seeds;
            m_seeds = NULL;
        }
        if(m_intervals) 
        {
            m_intervals->clear();
            delete m_seeds;
            m_intervals = NULL;
        }
        m_TotalDuration = 0.0f;
    }

    

    const int       GetSequenceIndex(const float currentTime,  const float deltaTime)
    {   
        
        if(deltaTime >=0)
        {
            int index = 0;
            for (const Interval& interval : (*m_intervals))
            {
                if(currentTime < interval.sup)
                {
                    /*char buff[256];
                    sprintf_s(buff, "Last index = %d, NewIndex = %d Time = %f, dt= %f \n", m_lastSequenceIndex, index, currentTime, deltaTime);
                    OutputDebugString(_bstr_t(buff));*/
                    m_lastSequenceIndex = index;
                    return m_lastSequenceIndex;
                }
                index++;
            }

             m_lastSequenceIndex = m_intervals->size() - 1;
        }
        else
        {
            int index = m_intervals->size() -1;
            for (vector<Interval>::const_reverse_iterator rit = m_intervals->rbegin(); rit < m_intervals->rend(); ++rit)
            {
                const Interval& interval = (*rit);
                if (currentTime >= interval.inf)
                {
                  /* char buff[256];
                    sprintf_s(buff, "Last index = %d, NewIndex = %d Time = %f, dt= %f, sup = %f \n", m_lastSequenceIndex, index, currentTime, deltaTime, interval.inf);
                    OutputDebugString(_bstr_t(buff));*/
                   m_lastSequenceIndex = index;
                    return m_lastSequenceIndex;
                }
                index--;
            }

            m_lastSequenceIndex = 0;
        }
       
        return m_lastSequenceIndex;
    }

private:
    float                           m_TotalDuration;
    std::vector<SequenceSeed>*      m_seeds;
    std::vector<Interval>*          m_intervals;
    int                             m_lastSequenceIndex;
};



